/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.scoring.Achievement;
import com.skloch.game.screens.GameScreen;
import com.skloch.game.screens.MenuScreen;
import com.skloch.game.screens.SettingsScreen;

public class EscapeMenu {
    private GameScreen gameScreen;
    private HustleGame game;
    public static Window escapeMenu;
    private Viewport viewport;
    private Stage uiStage;

    public EscapeMenu(HustleGame game, Viewport viewport, GameScreen gameScreen, Stage uiStage) {
        this.game = game;
        this.viewport = viewport;
        this.gameScreen = gameScreen;
        this.uiStage = uiStage;
        this.setupEscapeMenu(uiStage);
    }

    public void setupEscapeMenu(Stage interfaceStage) {
        escapeMenu = new Window("", this.game.skin);
        interfaceStage.addActor(escapeMenu);
        escapeMenu.setModal(true);
        Table escapeTable = new Table();
        escapeTable.setFillParent(true);
        escapeMenu.add(escapeTable);
        TextButton resumeButton = new TextButton("Resume", this.game.skin);
        escapeTable.add(resumeButton).pad(60.0f, 80.0f, 10.0f, 80.0f).width(300.0f);
        escapeTable.row();
        TextButton settingsButton = new TextButton("Settings", this.game.skin);
        escapeTable.add(settingsButton).pad(10.0f, 50.0f, 10.0f, 50.0f).width(300.0f);
        escapeTable.row();
        TextButton exitButton = new TextButton("Exit", this.game.skin);
        escapeTable.add(exitButton).pad(10.0f, 50.0f, 60.0f, 50.0f).width(300.0f);
        escapeMenu.pack();
        escapeMenu.setX(this.viewport.getWorldWidth() / 2.0f - escapeMenu.getWidth() / 2.0f - 275.0f);
        escapeMenu.setY(this.viewport.getWorldHeight() / 2.0f - escapeMenu.getHeight() / 2.0f - 150.0f);
        resumeButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (escapeMenu.isVisible()) {
                    ((EscapeMenu)EscapeMenu.this).game.soundManager.playButton();
                    ((EscapeMenu)EscapeMenu.this).game.soundManager.playOverworldMusic();
                    escapeMenu.setVisible(false);
                }
            }
        });
        final GameScreen thisScreen = this.gameScreen;
        settingsButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (escapeMenu.isVisible()) {
                    ((EscapeMenu)EscapeMenu.this).game.soundManager.playButton();
                    EscapeMenu.this.game.setScreen(new SettingsScreen(EscapeMenu.this.game, thisScreen));
                }
            }
        });
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (escapeMenu.isVisible()) {
                    ((EscapeMenu)EscapeMenu.this).game.soundManager.playButton();
                    ((EscapeMenu)EscapeMenu.this).game.soundManager.stopOverworldMusic();
                    EscapeMenu.this.gameScreen.dispose();
                    ((EscapeMenu)EscapeMenu.this).gameScreen.score.resetScores();
                    Achievement.getInstance().resetAllAchievements();
                    EscapeMenu.this.game.setScreen(new MenuScreen(EscapeMenu.this.game));
                }
            }
        });
        escapeMenu.setVisible(false);
    }
}

